Attribute VB_Name = "AddPartsList"
'       This is a part of the source code for Pro/DESKTOP.
'       Copyright (C) 2000 Parametric Technology Corporation.
'       All rights reserved.
'
'       Use this utility to create a custom parts list table using an existing one as a template.
'
' Usage:
'    1. Load this file into the VBA workspace. You will only need it once to set up the command.
'    2. Select a parts list table and run CustomPartsListGenerator(). This creates a file called
'       CustomPartsListTable.bas by default (you can choose a different name). A dialog prompts
'       you for the name and location. Choose a folder where you store VBA add-ins.
'    3. Use Tools/Add-ins... and add the newly created CustomPartsListTable.bas file.
'    4. This now gives you a command called "Add Custom Parts List" on the Table menu to create
'       your custom parts list table in any session. You need to select a view before running
'       this command.
'    5. Re-run CustomPartsListGenerator() to generate a new command file using the selected table
'       as a template. You will have to load the new file into the VBA workspace or re-run
'       Pro/DESKTOP.

Option Explicit

Public Sub CustomPartsListGenerator()
    Dim app As ProDESKTOP
    Set app = GetApp()

    Dim table As aPartsListTable
    On Error Resume Next
    Set table = app.GetActiveDoc.GetSingleSelection("PartsListTable")
    If table Is Nothing Then
        MsgBox "No Parts List Table selected", vbInformation
        Exit Sub
    End If
    On Error GoTo 0

    Dim basFile As String
    basFile = CurDir & "\" & "CustomPartsListTable.bas"
    basFile = InputBox("Enter pathname of .bas file", "Parts List Generator", basFile)
    If basFile = "" Then
        Exit Sub
    End If

    Dim fn As Integer
    fn = FreeFile

    On Error GoTo CantOpenFile
    Open basFile For Output As #fn
    On Error GoTo 0

    Dim partsList As aPartsList
    Set partsList = table.GetPartsList

    Print #fn, "Attribute VB_Name = ""CustomPartsListTable"""
    Print #fn, "' This file is generated by CustomPartsListGenerator()."
    Print #fn, "' If you edit this file, you should consider renaming it too so that it won't be"
    Print #fn, "' overwritten if you run CustomPartsListGenerator() again."
    Print #fn, ""
    Print #fn, "Option Explicit"
    Print #fn, "Private ext As IProDExtensibility, uc1 As userCommand"
    Print #fn, ""
    Print #fn, "Public Sub OnStartUp()"
    Print #fn, "    Set ext = GetApp"
    Print #fn, "    Set uc1 = ext.AddUserCommand(barDrawing, menuDrawingTable, 2, ""Add Custom Parts List"", ""CustomPartsList"", ""CustomPartsListTable.CustomPartsListTable"")"
    Print #fn, "    uc1.SetPrompt ""Adds a customized parts list table for the selected view"""
    Print #fn, "End Sub"
    Print #fn, ""
    Print #fn, "Public Sub OnCloseDown()"
    Print #fn, "    Set ext = GetApp"
    Print #fn, "    Set uc1 = ext.GetUserCommand(barDrawing, menuDrawingTable, ""Add Custom Parts List"")"
    Print #fn, "    ext.RemoveUserCommand uc1"
    Print #fn, "End Sub"
    Print #fn, ""
    Print #fn, "Public Sub CustomPartsListTable()"
    Print #fn, "    Dim app As ProDESKTOP"
    Print #fn, "    Set app = GetApp()"
    Print #fn, ""
    Print #fn, "    On Error GoTo noDrawing"
    Print #fn, "    Dim doc As DrawingDocument, dwg As aDrawing"
    Print #fn, "    Set doc = app.GetActiveDoc"
    Print #fn, "    Set dwg = doc.GetDrawing"
    Print #fn, "    On Error GoTo 0"
    Print #fn, ""
    Print #fn, "    Dim view As aView"
    Print #fn, "    Set view = doc.GetSingleSelection(""View"")"
    Print #fn, "    If view Is Nothing Then"
    Print #fn, "        MsgBox ""No view Selected"", vbInformation"
    Print #fn, "        Exit Sub"
    Print #fn, "    End If"
    Print #fn, "    On Error GoTo 0"
    Print #fn, ""
    Print #fn, "    Dim design As aDesign"
    Print #fn, "    Set design = view.GetDesign"
    Print #fn, ""
    Print #fn, "    Dim detail As aDesignDetail"
    Print #fn, "    Set detail = dwg.GetDetail(design, False)"
    Print #fn, ""
    Print #fn, "    Dim partsList As aPartsList"
    Print #fn, "    Set partsList = detail.GetPartsList"
    Print #fn, "    partsList.SetListing "; partsList.GetListing
    Print #fn, ""
    Dim pos As zVector
    Set pos = table.GetAnchorPoint(table.GetAnchor)
    Print #fn, "    Dim pos As zVector"
    Print #fn, "    Set pos = app.GetClass(""Vector"").CreateVector("; pos.GetAt(0); ", "; pos.GetAt(1); ", 0)"
    Print #fn, ""
    Print #fn, "    Dim textHeight As Double"
    Print #fn, "    textHeight = "; table.GetTextHeight
    Print #fn, ""
    Print #fn, "    Dim columnWidth As Double"
    Print #fn, "    columnWidth = 0.025  '25mm"
    Print #fn, ""
    Print #fn, "    Dim api As helm"
    Print #fn, "    Set api = app.TakeHelm"
    Print #fn, ""
    Print #fn, "    Dim table As aPartsListTable"
    Print #fn, "    Set table = app.GetClass(""PartsListTable"").CreatePartsListTable(partsList, pos, textHeight, 1, columnWidth, alignCenter)"
    Print #fn, "    table.SetShowBillOfMaterials "; table.GetShowBillOfMaterials
    Print #fn, "    table.SetInverted "; table.isInverted
    Print #fn, "    table.SetAnchor "; table.GetAnchor
    Print #fn, "    table.SetAnchorPoint "; table.GetAnchor; ", pos"
    Print #fn, ""
    Print #fn, "    Dim sheet as aSheet"
    Print #fn, "    Set sheet = view.GetParent(""Sheet"")"
    Print #fn, "    sheet.AddTable table"
    Print #fn, ""
    Print #fn, "    table.GetColumn(0).Delete"
    Print #fn, "    table.RemoveNodes"
    Print #fn, ""
    Print #fn, "    Dim column As aTableColumn, ind As Integer"
    Print #fn, ""
    
    Dim i As Integer, nNodes As Long

    Dim sortColumns As ObjectSet
    Set sortColumns = app.GetClass("ObjectSet").CreateAObjectSet()
    
    For i = 0 To table.GetSortKeyCount - 1
        Dim col As aTableColumn
        Set col = table.GetSortKey(i)
        sortColumns.AddMember col
    Next
    
    nNodes = table.GetNodeCount
    For i = 0 To nNodes - 1
        Dim Title As String, indent As Integer, column As aTableColumn
        Title = table.GetTitle(i)
        indent = table.GetIndent(i)
        Set column = table.GetColumn(i)

        If column Is Nothing Then
            Print #fn, "    Set column = Nothing"
            Print #fn, "    ind = table.AddNode("""; Title; """, "; indent; ", column)"
        Else
            Print #fn, "    Set column = app.GetClass(""TableColumn"").CreateTableColumn("; column.GetWidth; ", "; column.GetAlignment; ")"
            Print #fn, "    ind = table.AddNode("""; Title; """, "; indent; ", column)"

            Print #fn, "    table.SetColumnType column, "; table.GetColumnType(column)
            If table.GetColumnType(column) = itemStyleShowCustom Then
                Print #fn, "    table.SetColumnCustomName column, """; table.GetColumnCustomName(column); """"
            End If
            
            If sortColumns.Contains(column) Then
                Print #fn, "    table.AddSortKey column"
            End If
        End If
            
        Print #fn, ""
    Next

    Print #fn, "    api.CommitCalls ""Create Parts List Table"", False"
    Print #fn, "    Exit Sub"
    Print #fn, "noDrawing:"
    Print #fn, "    MsgBox ""There is no active drawing document"""
    Print #fn, "End Sub"

    Close #fn

    Exit Sub

CantOpenFile:
    MsgBox "Cannot open " + basFile
End Sub

